#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class ServiceStatsMetrics(APIObject):
    """
    Attributes
    ----------
    cache_hit_ratio:float, none_type
         Number of cache hits.
    execution_time:float, none_type
         Request execution time at `executionTimeQuantile` (in milliseconds).
    median_load:float, none_type
         Median of the request rate (in requests per minute).
    num_consumers:int, none_type
         Number of unique users performing requests.
    peak_load:float, none_type
         Maximum of the request rate (in requests per minute).
    response_time:float, none_type
         Request response time at `responseTimeQuantile` (in milliseconds).
    server_error_rate:float, none_type
         Ratio of server errors to the total number of requests.
    slow_requests:int, none_type
         Number of requests with response time greater than `slowRequestsThreshold`
    total_predictions:int, none_type
         Total number of prediction rows.
    total_requests:int, none_type
         Total number of prediction requests performed.
    user_error_rate:float, none_type
         Ratio of user errors to the total number of requests.
    """
    _converter = t.Dict(
        {
            t.Key("cache_hit_ratio"):  t.Float(),
            t.Key("execution_time"):  t.Float(),
            t.Key("median_load"):  t.Float(),
            t.Key("num_consumers"):  t.Int(),
            t.Key("peak_load"):  t.Float(),
            t.Key("response_time"):  t.Float(),
            t.Key("server_error_rate"):  t.Float(),
            t.Key("slow_requests"):  t.Int(),
            t.Key("total_predictions"):  t.Int(),
            t.Key("total_requests"):  t.Int(),
            t.Key("user_error_rate"):  t.Float(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        cache_hit_ratio,
        execution_time,
        median_load,
        num_consumers,
        peak_load,
        response_time,
        server_error_rate,
        slow_requests,
        total_predictions,
        total_requests,
        user_error_rate,
    ):
        self.cache_hit_ratio = cache_hit_ratio
        self.execution_time = execution_time
        self.median_load = median_load
        self.num_consumers = num_consumers
        self.peak_load = peak_load
        self.response_time = response_time
        self.server_error_rate = server_error_rate
        self.slow_requests = slow_requests
        self.total_predictions = total_predictions
        self.total_requests = total_requests
        self.user_error_rate = user_error_rate

    def __repr__(self):
        return (
            "ServiceStatsMetrics("
            "cache_hit_ratio={0.cache_hit_ratio}, "
            "execution_time={0.execution_time}, "
            "median_load={0.median_load}, "
            "num_consumers={0.num_consumers}, "
            "peak_load={0.peak_load}, "
            "response_time={0.response_time}, "
            "server_error_rate={0.server_error_rate}, "
            "slow_requests={0.slow_requests}, "
            "total_predictions={0.total_predictions}, "
            "total_requests={0.total_requests}, "
            "user_error_rate={0.user_error_rate}, "
        ).format(self)
