#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class ShapExplanationResponse(APIObject):
    """
    Attributes
    ----------
    feature:str
         Feature name
    feature_value:str
         Feature value for this row. First 50 characters are returned.
    strength:float
         Shapley value for this feature and row.
    """
    _converter = t.Dict(
        {
            t.Key("feature"):  t.String(),
            t.Key("feature_value"):  t.String(),
            t.Key("strength"):  t.Float(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        feature,
        feature_value,
        strength,
    ):
        self.feature = feature
        self.feature_value = feature_value
        self.strength = strength

    def __repr__(self):
        return (
            "ShapExplanationResponse("
            "feature={0.feature}, "
            "feature_value={0.feature_value}, "
            "strength={0.strength}, "
        ).format(self)
