#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.shap_explanations_warnings_values import ShapExplanationsWarningsValues

class ShapExplanationsMetadataValues(APIObject):
    """
    Attributes
    ----------
    base_value:float
         Will be present only if`explanationAlgorithm` = \"shap\". The model's average prediction over the training data. SHAP values are deviations from the base value.
    remaining_total:float, none_type
         Will be present only if `explanationAlgorithm` = \"shap\" and `maxExplanations` is nonzero. The total of SHAP values for features beyond the `maxExplanations`. This can be identically 0 in all rows, if `maxExplanations` is greater than the number of features and thus all features are returned.
    warnings:[ShapExplanationsWarningsValues], none_type
         Will be present if `explanationAlgorithm` was set to \"shap\" and there were additivity failures during SHAP values calculation.
    """
    _converter = t.Dict(
        {
            t.Key("base_value"):  t.Float(),
            t.Key("remaining_total"):  t.Float(),
            t.Key("warnings"):  t.List(t.Dict().allow_extra("*")),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        base_value,
        remaining_total,
        warnings,
    ):
        self.base_value = base_value
        self.remaining_total = remaining_total
        self.warnings = warnings

    def __repr__(self):
        return (
            "ShapExplanationsMetadataValues("
            "base_value={0.base_value}, "
            "remaining_total={0.remaining_total}, "
            "warnings={0.warnings}, "
        ).format(self)
