#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.shap_impacts_response import ShapImpactsResponse

class ShapImpactRetrieveResponse(APIObject):
    """
    Attributes
    ----------
    count:int
         The number of shapImpact object returned
    shap_impacts:[ShapImpactsResponse]
         A list which contains shap impact scores for top 1000 features used by a model
    row_count:int [optional]
         The number of rows from dataset to use.. 
    """
    _converter = t.Dict(
        {
            t.Key("count"):  t.Int(),
            t.Key("shap_impacts"):  t.List(t.Dict().allow_extra("*")),
            t.Key("row_count", optional=True):  t.Int(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        count,
        shap_impacts,
        row_count=None,
    ):
        self.count = count
        self.shap_impacts = shap_impacts
        self.row_count = row_count

    def __repr__(self):
        return (
            "ShapImpactRetrieveResponse("
            "count={0.count}, "
            "shap_impacts={0.shap_impacts}, "
            "row_count={0.row_count}, "
        ).format(self)
