#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class ShapImpactsResponse(APIObject):
    """
    Attributes
    ----------
    feature_name:str
         The feature name in dataset
    impact_normalized:float
         The normalized impact score value (largest value is 1)
    impact_unnormalized:float
         The raw impact score value
    """
    _converter = t.Dict(
        {
            t.Key("feature_name"):  t.String(),
            t.Key("impact_normalized"):  t.Float(),
            t.Key("impact_unnormalized"):  t.Float(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        feature_name,
        impact_normalized,
        impact_unnormalized,
    ):
        self.feature_name = feature_name
        self.impact_normalized = impact_normalized
        self.impact_unnormalized = impact_unnormalized

    def __repr__(self):
        return (
            "ShapImpactsResponse("
            "feature_name={0.feature_name}, "
            "impact_normalized={0.impact_normalized}, "
            "impact_unnormalized={0.impact_unnormalized}, "
        ).format(self)
