#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.shap_matrix_metadata_field import ShapMatrixMetadataField

class ShapMatrixListDataField(APIObject):
    """
    Attributes
    ----------
    dataset_id:str
         The dataset ID.
    id:str
         The ID of the SHAP matrix record.
    metadata:ShapMatrixMetadataField
        
    model_id:str
         The model ID.
    project_id:str
         The project ID.
    url:str
         The url at which you can retrieve the SHAP matrix.
    """
    _converter = t.Dict(
        {
            t.Key("dataset_id"):  t.String(),
            t.Key("id"):  t.String(),
            t.Key("metadata"):  t.Any(),
            t.Key("model_id"):  t.String(),
            t.Key("project_id"):  t.String(),
            t.Key("url"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        dataset_id,
        id,
        metadata,
        model_id,
        project_id,
        url,
    ):
        self.dataset_id = dataset_id
        self.id = id
        self.metadata = metadata
        self.model_id = model_id
        self.project_id = project_id
        self.url = url

    def __repr__(self):
        return (
            "ShapMatrixListDataField("
            "dataset_id={0.dataset_id}, "
            "id={0.id}, "
            "metadata={0.metadata}, "
            "model_id={0.model_id}, "
            "project_id={0.project_id}, "
            "url={0.url}, "
        ).format(self)
