#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class SharedRolesResponse(APIObject):
    """
    Attributes
    ----------
    can_share:bool
         True if this user can share with other users
    can_use_data:bool
         True if the user can view, download and process data (use to create projects, predictions, etc)
    id:str
         The ID of the recipient organization, group or user.
    name:str
         The name of the recipient organization, group or user.
    role:str
         The role of the org/group/user on this dataset or \"NO_ROLE\" for removing access when used with route to modify access.
    share_recipient_type:str
         It describes the recipient type.
    user_full_name:str [optional]
         If the recipient type is a user, the full name of the user if available.. 
    """
    _converter = t.Dict(
        {
            t.Key("can_share"):  t.Bool(),
            t.Key("can_use_data"):  t.Bool(),
            t.Key("id"):  t.String(),
            t.Key("name"):  t.String(),
            t.Key("role"):  t.String(),
            t.Key("share_recipient_type"):  t.String(),
            t.Key("user_full_name", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        can_share,
        can_use_data,
        id,
        name,
        role,
        share_recipient_type,
        user_full_name=None,
    ):
        self.can_share = can_share
        self.can_use_data = can_use_data
        self.id = id
        self.name = name
        self.role = role
        self.share_recipient_type = share_recipient_type
        self.user_full_name = user_full_name

    def __repr__(self):
        return (
            "SharedRolesResponse("
            "can_share={0.can_share}, "
            "can_use_data={0.can_use_data}, "
            "id={0.id}, "
            "name={0.name}, "
            "role={0.role}, "
            "share_recipient_type={0.share_recipient_type}, "
            "user_full_name={0.user_full_name}, "
        ).format(self)
