#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class SharingRoleUpdateData(APIObject):
    """
    Attributes
    ----------
    role:str
         The assigned role
    share_recipient_type:str
         The recipient type
    id:str [optional]
         The ID of the recipient. 
    username:str [optional]
         The name of the user, group, or organization. 
    """
    _converter = t.Dict(
        {
            t.Key("role"):  t.String(),
            t.Key("share_recipient_type"):  t.String(),
            t.Key("id", optional=True):  t.String(),
            t.Key("username", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        role,
        share_recipient_type,
        id=None,
        username=None,
    ):
        self.role = role
        self.share_recipient_type = share_recipient_type
        self.id = id
        self.username = username

    def __repr__(self):
        return (
            "SharingRoleUpdateData("
            "role={0.role}, "
            "share_recipient_type={0.share_recipient_type}, "
            "id={0.id}, "
            "username={0.username}, "
        ).format(self)
