#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.update_access_control import UpdateAccessControl

class SharingUpdateOrRemove(APIObject):
    """
    Attributes
    ----------
    data:[UpdateAccessControl]
         The role to set for the user.
    include_feature_discovery_entities:bool [optional]
         Whether to share all the related entities..  if omitted the server will use the default value of False
    send_notification:bool [optional]
         Send an email notification..  if omitted the server will use the default value of True
    """
    _converter = t.Dict(
        {
            t.Key("data"):  t.List(t.Dict().allow_extra("*")),
            t.Key("include_feature_discovery_entities", optional=True):  t.Bool(),
            t.Key("send_notification", optional=True):  t.Bool(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        data,
        include_feature_discovery_entities=None,
        send_notification=None,
    ):
        self.data = data
        self.include_feature_discovery_entities = include_feature_discovery_entities
        self.send_notification = send_notification

    def __repr__(self):
        return (
            "SharingUpdateOrRemove("
            "data={0.data}, "
            "include_feature_discovery_entities={0.include_feature_discovery_entities}, "
            "send_notification={0.send_notification}, "
        ).format(self)
