#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class SolutionResponse(APIObject):
    """
    Attributes
    ----------
    best_model:bool
         True if this solution generates the best model.
    complexity:int
         The complexity score for this solution. Complexity score is a function of the mathematical operators used in the current solution. The complexity calculation can be tuned via model hyperparameters.
    error:float, none_type
         The error for the current solution, as computed by eureqa using the `errorMetric` error metric. None if Eureqa model refitted existing solutions.
    eureqa_solution_id:str
         The ID of the solution.
    expression:str
         The eureqa \"solution string\". This is a mathematical expression; human-readable but with strict syntax specifications defined by Eureqa.
    expression_annotated:str
         The `expression`, rendered with additional tags to assist in automatic parsing.
    """
    _converter = t.Dict(
        {
            t.Key("best_model"):  t.Bool(),
            t.Key("complexity"):  t.Int(),
            t.Key("error"):  t.Float(),
            t.Key("eureqa_solution_id"):  t.String(),
            t.Key("expression"):  t.String(),
            t.Key("expression_annotated"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        best_model,
        complexity,
        error,
        eureqa_solution_id,
        expression,
        expression_annotated,
    ):
        self.best_model = best_model
        self.complexity = complexity
        self.error = error
        self.eureqa_solution_id = eureqa_solution_id
        self.expression = expression
        self.expression_annotated = expression_annotated

    def __repr__(self):
        return (
            "SolutionResponse("
            "best_model={0.best_model}, "
            "complexity={0.complexity}, "
            "error={0.error}, "
            "eureqa_solution_id={0.eureqa_solution_id}, "
            "expression={0.expression}, "
            "expression_annotated={0.expression_annotated}, "
        ).format(self)
