#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class StatusRetrieveResponse(APIObject):
    """
    Attributes
    ----------
    code:int
         If no error occurred, 0.  Otherwise, may contain a status code reflecting the error.
    created:datetime
         The time the status record was created.
    description:str, none_type
         A description of the Task being performed, if applicable.
    message:str, none_type
         May contain further information about the status.
    status:str
         The status of the task.
    status_id:str
         The ID of the status object.
    status_type:str, none_type [optional]
         The type of thing being created by the Task, if applicable.. 
    type:str, none_type [optional]
         The type of thing being created by the Task, if applicable.. 
    """
    _converter = t.Dict(
        {
            t.Key("code"):  t.Int(),
            t.Key("created"):  t.DateTime(),
            t.Key("description"):  t.String(),
            t.Key("message"):  t.String(),
            t.Key("status"):  t.String(),
            t.Key("status_id"):  t.String(),
            t.Key("status_type", optional=True):  t.String(),
            t.Key("type", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        code,
        created,
        description,
        message,
        status,
        status_id,
        status_type=None,
        type=None,
    ):
        self.code = code
        self.created = created
        self.description = description
        self.message = message
        self.status = status
        self.status_id = status_id
        self.status_type = status_type
        self.type = type

    def __repr__(self):
        return (
            "StatusRetrieveResponse("
            "code={0.code}, "
            "created={0.created}, "
            "description={0.description}, "
            "message={0.message}, "
            "status={0.status}, "
            "status_id={0.status_id}, "
            "status_type={0.status_type}, "
            "type={0.type}, "
        ).format(self)
