#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class SynapseOutput(APIObject):
    """
    Attributes
    ----------
    data_store_id:str
         ID of the data store to connect to
    external_data_source:str
         External data source name
    statement_type:str
         The statement type to use when writing the results.
    table:str
         The name of the specified database table to write results to.
    type:str
         Type name for this output type. defaults to "synapse", must be one of ["synapse", ]
    cloud_storage_credential_id:str, none_type [optional]
         The ID of the credential holding information about a user with write access to the cloud storage.. 
    create_table_if_not_exists:bool [optional]
         Attempt to create the table first if no existing one is detected, before writing data with the strategy defined in the `statementType` parameter..  if omitted the server will use the default value of False
    credential_id:str, none_type [optional]
         The ID of the credential holding information about a user with write access to the JDBC data source.. 
    schema:str [optional]
         The name of the specified database schema to write results to.. 
    """
    _converter = t.Dict(
        {
            t.Key("data_store_id"):  t.String(),
            t.Key("external_data_source"):  t.String(),
            t.Key("statement_type"):  t.String(),
            t.Key("table"):  t.String(),
            t.Key("type"):  t.String(),
            t.Key("cloud_storage_credential_id", optional=True):  t.String(),
            t.Key("create_table_if_not_exists", optional=True):  t.Bool(),
            t.Key("credential_id", optional=True):  t.String(),
            t.Key("schema", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        data_store_id,
        external_data_source,
        statement_type,
        table,
        type,
        cloud_storage_credential_id=None,
        create_table_if_not_exists=None,
        credential_id=None,
        schema=None,
    ):
        self.data_store_id = data_store_id
        self.external_data_source = external_data_source
        self.statement_type = statement_type
        self.table = table
        self.type = type
        self.cloud_storage_credential_id = cloud_storage_credential_id
        self.create_table_if_not_exists = create_table_if_not_exists
        self.credential_id = credential_id
        self.schema = schema

    def __repr__(self):
        return (
            "SynapseOutput("
            "data_store_id={0.data_store_id}, "
            "external_data_source={0.external_data_source}, "
            "statement_type={0.statement_type}, "
            "table={0.table}, "
            "type={0.type}, "
            "cloud_storage_credential_id={0.cloud_storage_credential_id}, "
            "create_table_if_not_exists={0.create_table_if_not_exists}, "
            "credential_id={0.credential_id}, "
            "schema={0.schema}, "
        ).format(self)
