#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class TableDescription(APIObject):
    """
    Attributes
    ----------
    name:str
         Name of the table.
    type:str
         Type of table.
    catalog:str [optional]
         Name of the catalog.. 
    schema:str [optional]
         Schema of the table.. 
    """
    _converter = t.Dict(
        {
            t.Key("name"):  t.String(),
            t.Key("type"):  t.String(),
            t.Key("catalog", optional=True):  t.String(),
            t.Key("schema", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        name,
        type,
        catalog=None,
        schema=None,
    ):
        self.name = name
        self.type = type
        self.catalog = catalog
        self.schema = schema

    def __repr__(self):
        return (
            "TableDescription("
            "name={0.name}, "
            "type={0.type}, "
            "catalog={0.catalog}, "
            "schema={0.schema}, "
        ).format(self)
