#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class Tableau(APIObject):
    """
    Attributes
    ----------
    data_source_id:str
         The ID of your Tableau data source
    overwrite:bool
         Should the dataset be overwritten or appended to
    type:str
         Type name for this output type. defaults to "tableau", must be one of ["tableau", ]
    url:str
         The URL to your online Tableau server
    content_url:str [optional]
         Deprecated, use `siteName` instead. 
    credential_id:str [optional]
         Use the specified credential to access the url. 
    site_name:str [optional]
         Your Tableau site name. 
    """
    _converter = t.Dict(
        {
            t.Key("data_source_id"):  t.String(),
            t.Key("overwrite"):  t.Bool(),
            t.Key("type"):  t.String(),
            t.Key("url"):  t.String(),
            t.Key("content_url", optional=True):  t.String(),
            t.Key("credential_id", optional=True):  t.String(),
            t.Key("site_name", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        data_source_id,
        overwrite,
        type,
        url,
        content_url=None,
        credential_id=None,
        site_name=None,
    ):
        self.data_source_id = data_source_id
        self.overwrite = overwrite
        self.type = type
        self.url = url
        self.content_url = content_url
        self.credential_id = credential_id
        self.site_name = site_name

    def __repr__(self):
        return (
            "Tableau("
            "data_source_id={0.data_source_id}, "
            "overwrite={0.overwrite}, "
            "type={0.type}, "
            "url={0.url}, "
            "content_url={0.content_url}, "
            "credential_id={0.credential_id}, "
            "site_name={0.site_name}, "
        ).format(self)
