#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class TableauServerPredictionTargetPayload(APIObject):
    """
    Attributes
    ----------
    content_url:str
         Site name of the Tableau online or Tableau server you wish to use. Required for Tableau online users.
    datasource_id:str
         Id of the DSS data source object
    password:str
         User password to connect to the data location
    type_id:str
         For Tableau should be set to `tableauServer`. defaults to "tableauServer", must be one of ["tableauServer", ]
    url:str
         Url of the Tableau online or Tableau server instance
    user_name:str
         User name to connect to the data location
    """
    _converter = t.Dict(
        {
            t.Key("content_url"):  t.String(),
            t.Key("datasource_id"):  t.String(),
            t.Key("password"):  t.String(),
            t.Key("type_id"):  t.String(),
            t.Key("url"):  t.String(),
            t.Key("user_name"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        content_url,
        datasource_id,
        password,
        type_id,
        url,
        user_name,
    ):
        self.content_url = content_url
        self.datasource_id = datasource_id
        self.password = password
        self.type_id = type_id
        self.url = url
        self.user_name = user_name

    def __repr__(self):
        return (
            "TableauServerPredictionTargetPayload("
            "content_url={0.content_url}, "
            "datasource_id={0.datasource_id}, "
            "password={0.password}, "
            "type_id={0.type_id}, "
            "url={0.url}, "
            "user_name={0.user_name}, "
        ).format(self)
