#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class TableauServerPredictionTargetResponse(APIObject):
    """
    Attributes
    ----------
    content_url:str
         Site name of the Tableau online or Tableau server you wish to use. Required for Tableau online users.
    credential_id:str
         Id of the stored credentials
    datasource_id:str
         Id of the DSS data source object
    type_id:str
         For Tableau should be set to `tableauServer`. defaults to "tableauServer", must be one of ["tableauServer", ]
    url:str
         Url of the Tableau online or Tableau server instance
    """
    _converter = t.Dict(
        {
            t.Key("content_url"):  t.String(),
            t.Key("credential_id"):  t.String(),
            t.Key("datasource_id"):  t.String(),
            t.Key("type_id"):  t.String(),
            t.Key("url"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        content_url,
        credential_id,
        datasource_id,
        type_id,
        url,
    ):
        self.content_url = content_url
        self.credential_id = credential_id
        self.datasource_id = datasource_id
        self.type_id = type_id
        self.url = url

    def __repr__(self):
        return (
            "TableauServerPredictionTargetResponse("
            "content_url={0.content_url}, "
            "credential_id={0.credential_id}, "
            "datasource_id={0.datasource_id}, "
            "type_id={0.type_id}, "
            "url={0.url}, "
        ).format(self)
