#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.template_permissions_response import TemplatePermissionsResponse

class TemplateResponse(APIObject):
    """
    Attributes
    ----------
    creator_id:str
         The ID of the user who created the template
    creator_username:str
         The username of the user who created the template
    date_modified:datetime, none_type
         Last date/time of template modification.
    description:str, none_type
         An overview of the template
    id:str
         The ID of the template accessible by the user
    instructions:str, none_type
         Currently always returns ``null``. Maintained as a placeholder for future functionality.
    labels:[str], none_type
         User-added filtering labels for the template
    name:str
         The name of the template
    org_id:str
         The ID of the organization the user who created the template belongs to
    permissions:TemplatePermissionsResponse
        
    project_type:str, none_type
         Type of project template.
    sections:[bool, date, datetime, dict, float, int, list, str, none_type]
         List of section objects representing the structure of the document. Each section can have sub-sections that have the same schema as the parent section, i.e., the structure is recursive. The number of nested sections allowed is 5. The total number of sections allowed is 500. 
    """
    _converter = t.Dict(
        {
            t.Key("creator_id"):  t.String(),
            t.Key("creator_username"):  t.String(),
            t.Key("date_modified"):  t.DateTime(),
            t.Key("description"):  t.String(),
            t.Key("id"):  t.String(),
            t.Key("instructions"):  t.String(),
            t.Key("labels"):  t.List(t.Dict().allow_extra("*")),
            t.Key("name"):  t.String(),
            t.Key("org_id"):  t.String(),
            t.Key("permissions"):  t.Any(),
            t.Key("project_type"):  t.String(),
            t.Key("sections"):  t.List(t.Dict().allow_extra("*")),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        creator_id,
        creator_username,
        date_modified,
        description,
        id,
        instructions,
        labels,
        name,
        org_id,
        permissions,
        project_type,
        sections,
    ):
        self.creator_id = creator_id
        self.creator_username = creator_username
        self.date_modified = date_modified
        self.description = description
        self.id = id
        self.instructions = instructions
        self.labels = labels
        self.name = name
        self.org_id = org_id
        self.permissions = permissions
        self.project_type = project_type
        self.sections = sections

    def __repr__(self):
        return (
            "TemplateResponse("
            "creator_id={0.creator_id}, "
            "creator_username={0.creator_username}, "
            "date_modified={0.date_modified}, "
            "description={0.description}, "
            "id={0.id}, "
            "instructions={0.instructions}, "
            "labels={0.labels}, "
            "name={0.name}, "
            "org_id={0.org_id}, "
            "permissions={0.permissions}, "
            "project_type={0.project_type}, "
            "sections={0.sections}, "
        ).format(self)
