#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class TimeSeriesFeatureLogListControllerResponse(APIObject):
    """
    Attributes
    ----------
    count:int
         The number of items returned on this page.
    feature_log:str
         The content of the feature log.
    next:str, none_type
         URL pointing to the next page (if null, there is no next page).
    previous:str, none_type
         URL pointing to the previous page (if null, there is no previous page).
    total_log_lines:int
         The total number of lines in feature derivation log.
    """
    _converter = t.Dict(
        {
            t.Key("count"):  t.Int(),
            t.Key("feature_log"):  t.String(),
            t.Key("next"):  t.String(),
            t.Key("previous"):  t.String(),
            t.Key("total_log_lines"):  t.Int(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        count,
        feature_log,
        next,
        previous,
        total_log_lines,
    ):
        self.count = count
        self.feature_log = feature_log
        self.next = next
        self.previous = previous
        self.total_log_lines = total_log_lines

    def __repr__(self):
        return (
            "TimeSeriesFeatureLogListControllerResponse("
            "count={0.count}, "
            "feature_log={0.feature_log}, "
            "next={0.next}, "
            "previous={0.previous}, "
            "total_log_lines={0.total_log_lines}, "
        ).format(self)
