#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class TimeSeriesFieldsPayload(APIObject):
    """
    Attributes
    ----------
    relax_known_in_advance_features_check:bool, none_type
         If `True`, missing values in the known in advance features are allowed in the forecast window at the prediction time. If omitted or `False`, missing values are not allowed.. defaults to False
    type:str
         One of forecast, historical
    forecast_point:str, none_type [optional]
         A template of format for the expected day of prediction. 
    prediction_end_date:str, none_type [optional]
         A template of format for the end date of prediction. 
    prediction_start_date:str, none_type [optional]
         A template of format for the start date of prediction. 
    """
    _converter = t.Dict(
        {
            t.Key("relax_known_in_advance_features_check"):  t.Bool(),
            t.Key("type"):  t.String(),
            t.Key("forecast_point", optional=True):  t.String(),
            t.Key("prediction_end_date", optional=True):  t.String(),
            t.Key("prediction_start_date", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        relax_known_in_advance_features_check,
        type,
        forecast_point=None,
        prediction_end_date=None,
        prediction_start_date=None,
    ):
        self.relax_known_in_advance_features_check = relax_known_in_advance_features_check
        self.type = type
        self.forecast_point = forecast_point
        self.prediction_end_date = prediction_end_date
        self.prediction_start_date = prediction_start_date

    def __repr__(self):
        return (
            "TimeSeriesFieldsPayload("
            "relax_known_in_advance_features_check={0.relax_known_in_advance_features_check}, "
            "type={0.type}, "
            "forecast_point={0.forecast_point}, "
            "prediction_end_date={0.prediction_end_date}, "
            "prediction_start_date={0.prediction_start_date}, "
        ).format(self)
