#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class TrainDatetimeFrozenModel(APIObject):
    """
    Attributes
    ----------
    model_id:str
         The ID of an existing model to use as the source for the training parameters.
    sampling_method:str [optional]
         Defines how training data is selected if subsampling is used (e.g., if `timeWindowSamplePct` is specified). Can be either ``random`` or ``latest``. If omitted, defaults to ``latest`` if `trainingRowCount` is used and ``random`` for other cases (e.g., if `trainingDuration` or `useProjectSettings` is specified). May only be specified for OTV projects.. 
    time_window_sample_pct:int [optional]
         An integer between 1 and 99 indicating the percentage of sampling within the time window. The points kept are determined by the value provided for the `samplingMethod` option. If specified, `trainingRowCount` may not be specified, and the specified model must either be a duration or selectedDateRange model, or one of `trainingDuration` or `trainingStartDate` and `trainingEndDate` must be specified.. 
    training_duration:str [optional]
         A duration string representing the training duration for the submitted model. Only one of `trainingDuration`, `trainingRowCount`, `trainingStartDate` and `trainingEndDate`, or `useProjectSettings` may be specified.. 
    training_end_date:datetime [optional]
         A datetime string representing the end date of the data to use for training this model. If specified, `trainingStartDate` must also be specified. Only one of `trainingDuration`, `trainingRowCount`, `trainingStartDate` and `trainingEndDate`, or `useProjectSettings` may be specified.. 
    training_row_count:int [optional]
         The number of rows of data that should be used when training this model. Only one of `trainingDuration`, `trainingRowCount`, `trainingStartDate` and `trainingEndDate`, or `useProjectSettings` may be specified.. 
    training_start_date:datetime [optional]
         A datetime string representing the start date of the data to use for training this model. If specified, `trainingEndDate` must also be specified. Only one of `trainingDuration`, `trainingRowCount`, `trainingStartDate` and `trainingEndDate`, or `useProjectSettings` may be specified.. 
    use_project_settings:bool [optional]
         If ``True``, the model will be trained using the previously-specified custom backtest training settings. Only one of `trainingDuration`, `trainingRowCount`, `trainingStartDate` and `trainingEndDate`, or `useProjectSettings` may be specified.. 
    """
    _converter = t.Dict(
        {
            t.Key("model_id"):  t.String(),
            t.Key("sampling_method", optional=True):  t.String(),
            t.Key("time_window_sample_pct", optional=True):  t.Int(),
            t.Key("training_duration", optional=True):  t.String(),
            t.Key("training_end_date", optional=True):  t.DateTime(),
            t.Key("training_row_count", optional=True):  t.Int(),
            t.Key("training_start_date", optional=True):  t.DateTime(),
            t.Key("use_project_settings", optional=True):  t.Bool(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        model_id,
        sampling_method=None,
        time_window_sample_pct=None,
        training_duration=None,
        training_end_date=None,
        training_row_count=None,
        training_start_date=None,
        use_project_settings=None,
    ):
        self.model_id = model_id
        self.sampling_method = sampling_method
        self.time_window_sample_pct = time_window_sample_pct
        self.training_duration = training_duration
        self.training_end_date = training_end_date
        self.training_row_count = training_row_count
        self.training_start_date = training_start_date
        self.use_project_settings = use_project_settings

    def __repr__(self):
        return (
            "TrainDatetimeFrozenModel("
            "model_id={0.model_id}, "
            "sampling_method={0.sampling_method}, "
            "time_window_sample_pct={0.time_window_sample_pct}, "
            "training_duration={0.training_duration}, "
            "training_end_date={0.training_end_date}, "
            "training_row_count={0.training_row_count}, "
            "training_start_date={0.training_start_date}, "
            "use_project_settings={0.use_project_settings}, "
        ).format(self)
