#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class TrainDatetimeModel(APIObject):
    """
    Attributes
    ----------
    blueprint_id:str
         The ID of a blueprint to use to generate the model. Allowed blueprints can be retrieved using :http:get:`/api/v2/projects/(projectId)/blueprints/` or taken from existing models.
    featurelist_id:str [optional]
         If specified, the model will be trained using this featurelist. If not specified, the recommended featurelist for the specified blueprint will be used. If there is no recommended featurelist, the project's default will be used.. 
    monotonic_decreasing_featurelist_id:str, none_type [optional]
         The ID of the featurelist that defines the set of features with a monotonically decreasing relationship to the target. If ``null``, no constraints will be enforced. If omitted, the project default is used. May only be specified for OTV projects.. 
    monotonic_increasing_featurelist_id:str, none_type [optional]
         The ID of the featurelist that defines the set of features with a monotonically increasing relationship to the target. If ``null``, no constraints will be enforced. If omitted, the project default is used. May only be specified for OTV projects.. 
    sampling_method:str [optional]
         Defines how training data is selected if subsampling is used (e.g., if `timeWindowSamplePct` is specified). Can be either ``random`` or ``latest``. If omitted, defaults to ``latest`` if `trainingRowCount` is used and ``random`` for other cases (e.g., if `trainingDuration` or `useProjectSettings` is specified). May only be specified for OTV projects.. 
    source_project_id:str [optional]
         The project the blueprint comes from. Required only if the `blueprintId` comes from a different project.. 
    time_window_sample_pct:int [optional]
         An integer between 1 and 99 indicating the percentage of sampling within the time window. The points kept are determined by the value provided for the `samplingMethod` option. If specified, `trainingRowCount` may not be specified, and the specified model must either be a duration or selectedDateRange model, or one of `trainingDuration` or `trainingStartDate` and `trainingEndDate` must be specified.. 
    training_duration:str [optional]
         A duration string representing the training duration for the submitted model.. 
    training_row_count:int [optional]
         The number of rows of data that should be used when training this model.. 
    use_project_settings:bool [optional]
         If ``True``, the model will be trained using the previously-specified custom backtest training settings.. 
    """
    _converter = t.Dict(
        {
            t.Key("blueprint_id"):  t.String(),
            t.Key("featurelist_id", optional=True):  t.String(),
            t.Key("monotonic_decreasing_featurelist_id", optional=True):  t.String(),
            t.Key("monotonic_increasing_featurelist_id", optional=True):  t.String(),
            t.Key("sampling_method", optional=True):  t.String(),
            t.Key("source_project_id", optional=True):  t.String(),
            t.Key("time_window_sample_pct", optional=True):  t.Int(),
            t.Key("training_duration", optional=True):  t.String(),
            t.Key("training_row_count", optional=True):  t.Int(),
            t.Key("use_project_settings", optional=True):  t.Bool(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        blueprint_id,
        featurelist_id=None,
        monotonic_decreasing_featurelist_id=None,
        monotonic_increasing_featurelist_id=None,
        sampling_method=None,
        source_project_id=None,
        time_window_sample_pct=None,
        training_duration=None,
        training_row_count=None,
        use_project_settings=None,
    ):
        self.blueprint_id = blueprint_id
        self.featurelist_id = featurelist_id
        self.monotonic_decreasing_featurelist_id = monotonic_decreasing_featurelist_id
        self.monotonic_increasing_featurelist_id = monotonic_increasing_featurelist_id
        self.sampling_method = sampling_method
        self.source_project_id = source_project_id
        self.time_window_sample_pct = time_window_sample_pct
        self.training_duration = training_duration
        self.training_row_count = training_row_count
        self.use_project_settings = use_project_settings

    def __repr__(self):
        return (
            "TrainDatetimeModel("
            "blueprint_id={0.blueprint_id}, "
            "featurelist_id={0.featurelist_id}, "
            "monotonic_decreasing_featurelist_id={0.monotonic_decreasing_featurelist_id}, "
            "monotonic_increasing_featurelist_id={0.monotonic_increasing_featurelist_id}, "
            "sampling_method={0.sampling_method}, "
            "source_project_id={0.source_project_id}, "
            "time_window_sample_pct={0.time_window_sample_pct}, "
            "training_duration={0.training_duration}, "
            "training_row_count={0.training_row_count}, "
            "use_project_settings={0.use_project_settings}, "
        ).format(self)
