#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class TrainModel(APIObject):
    """
    Attributes
    ----------
    blueprint_id:str
         The ID of a blueprint to use to generate the model. Allowed blueprints can be retrieved using :http:get:`/api/v2/projects/(projectId)/blueprints/` or taken from existing models.
    featurelist_id:str [optional]
         If specified, the model will be trained using this featurelist. If not specified, the recommended featurelist for the specified blueprint will be used. If there is no recommended featurelist, the project's default will be used.. 
    monotonic_decreasing_featurelist_id:str, none_type [optional]
         The ID of the featurelist that defines the set of features with a monotonically decreasing relationship to the target. If ``null``, no constraints will be enforced. If omitted, the project default is used.. 
    monotonic_increasing_featurelist_id:str, none_type [optional]
         The ID of the featurelist that defines the set of features with a monotonically increasing relationship to the target. If ``null``, no constraints will be enforced. If omitted, the project default is used.. 
    sample_pct:float [optional]
         The percentage of the dataset to use with the model. Only one of `samplePct` and `trainingRowCount` should be specified. The specified percentage should be between 0 and 100.. 
    scoring_type:str [optional]
         Validation is available for any partitioning. If the project uses cross validation, `crossValidation` may be used to indicate that all available training/validation combinations should be used.. 
    source_project_id:str [optional]
         The project the blueprint comes from. Required only if the `blueprintId` comes from a different project.. 
    training_row_count:int [optional]
         An integer representing the number of rows of the dataset to use with the model. Only one of `samplePct` and `trainingRowCount` should be specified.. 
    """
    _converter = t.Dict(
        {
            t.Key("blueprint_id"):  t.String(),
            t.Key("featurelist_id", optional=True):  t.String(),
            t.Key("monotonic_decreasing_featurelist_id", optional=True):  t.String(),
            t.Key("monotonic_increasing_featurelist_id", optional=True):  t.String(),
            t.Key("sample_pct", optional=True):  t.Float(),
            t.Key("scoring_type", optional=True):  t.String(),
            t.Key("source_project_id", optional=True):  t.String(),
            t.Key("training_row_count", optional=True):  t.Int(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        blueprint_id,
        featurelist_id=None,
        monotonic_decreasing_featurelist_id=None,
        monotonic_increasing_featurelist_id=None,
        sample_pct=None,
        scoring_type=None,
        source_project_id=None,
        training_row_count=None,
    ):
        self.blueprint_id = blueprint_id
        self.featurelist_id = featurelist_id
        self.monotonic_decreasing_featurelist_id = monotonic_decreasing_featurelist_id
        self.monotonic_increasing_featurelist_id = monotonic_increasing_featurelist_id
        self.sample_pct = sample_pct
        self.scoring_type = scoring_type
        self.source_project_id = source_project_id
        self.training_row_count = training_row_count

    def __repr__(self):
        return (
            "TrainModel("
            "blueprint_id={0.blueprint_id}, "
            "featurelist_id={0.featurelist_id}, "
            "monotonic_decreasing_featurelist_id={0.monotonic_decreasing_featurelist_id}, "
            "monotonic_increasing_featurelist_id={0.monotonic_increasing_featurelist_id}, "
            "sample_pct={0.sample_pct}, "
            "scoring_type={0.scoring_type}, "
            "source_project_id={0.source_project_id}, "
            "training_row_count={0.training_row_count}, "
        ).format(self)
