#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class TrainingDataAssignment(APIObject):
    """
    Attributes
    ----------
    dataset_id:str
         The ID of the dataset.
    dataset_version_id:str [optional]
         The ID of the dataset version.. 
    partition_column:str [optional]
         The name of the column containing the partition assignments.. 
    """
    _converter = t.Dict(
        {
            t.Key("dataset_id"):  t.String(),
            t.Key("dataset_version_id", optional=True):  t.String(),
            t.Key("partition_column", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        dataset_id,
        dataset_version_id=None,
        partition_column=None,
    ):
        self.dataset_id = dataset_id
        self.dataset_version_id = dataset_version_id
        self.partition_column = partition_column

    def __repr__(self):
        return (
            "TrainingDataAssignment("
            "dataset_id={0.dataset_id}, "
            "dataset_version_id={0.dataset_version_id}, "
            "partition_column={0.partition_column}, "
        ).format(self)
