#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class TrainingHistoryEntry(APIObject):
    """
    Attributes
    ----------
    creation_date:str
         ISO-8601 timestamp of when the project the blueprint was trained on was created.
    lid:str
         The leaderboard ID the blueprint was trained on.
    pid:str
         The project ID the blueprint was trained on.
    project_models_count:int
         Number of models in the project the blueprint was trained on.
    project_name:str
         The project name the blueprint was trained on.
    target_name:str
         The target name of the project the blueprint was trained on.
    """
    _converter = t.Dict(
        {
            t.Key("creation_date"):  t.String(),
            t.Key("lid"):  t.String(),
            t.Key("pid"):  t.String(),
            t.Key("project_models_count"):  t.Int(),
            t.Key("project_name"):  t.String(),
            t.Key("target_name"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        creation_date,
        lid,
        pid,
        project_models_count,
        project_name,
        target_name,
    ):
        self.creation_date = creation_date
        self.lid = lid
        self.pid = pid
        self.project_models_count = project_models_count
        self.project_name = project_name
        self.target_name = target_name

    def __repr__(self):
        return (
            "TrainingHistoryEntry("
            "creation_date={0.creation_date}, "
            "lid={0.lid}, "
            "pid={0.pid}, "
            "project_models_count={0.project_models_count}, "
            "project_name={0.project_name}, "
            "target_name={0.target_name}, "
        ).format(self)
