#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class TrainingInfoResponse(APIObject):
    """
    Attributes
    ----------
    holdout_training_duration:str
         the duration of the data used to train a model to score the holdout
    holdout_training_end_date:datetime
         the end date of the data used to train a model to score the holdout
    holdout_training_row_count:int
         the number of rows used to train a model to score the holdout
    holdout_training_start_date:datetime
         the start date of data used to train a model to score the holdout
    prediction_training_duration:str
         the duration of the data used to train a model to make predictions
    prediction_training_end_date:datetime
         the end date of the data used to train a model to make predictions
    prediction_training_row_count:int
         the number of rows used to train a model to make predictions
    prediction_training_start_date:datetime
         the start date of data used to train a model to make predictions
    """
    _converter = t.Dict(
        {
            t.Key("holdout_training_duration"):  t.String(),
            t.Key("holdout_training_end_date"):  t.DateTime(),
            t.Key("holdout_training_row_count"):  t.Int(),
            t.Key("holdout_training_start_date"):  t.DateTime(),
            t.Key("prediction_training_duration"):  t.String(),
            t.Key("prediction_training_end_date"):  t.DateTime(),
            t.Key("prediction_training_row_count"):  t.Int(),
            t.Key("prediction_training_start_date"):  t.DateTime(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        holdout_training_duration,
        holdout_training_end_date,
        holdout_training_row_count,
        holdout_training_start_date,
        prediction_training_duration,
        prediction_training_end_date,
        prediction_training_row_count,
        prediction_training_start_date,
    ):
        self.holdout_training_duration = holdout_training_duration
        self.holdout_training_end_date = holdout_training_end_date
        self.holdout_training_row_count = holdout_training_row_count
        self.holdout_training_start_date = holdout_training_start_date
        self.prediction_training_duration = prediction_training_duration
        self.prediction_training_end_date = prediction_training_end_date
        self.prediction_training_row_count = prediction_training_row_count
        self.prediction_training_start_date = prediction_training_start_date

    def __repr__(self):
        return (
            "TrainingInfoResponse("
            "holdout_training_duration={0.holdout_training_duration}, "
            "holdout_training_end_date={0.holdout_training_end_date}, "
            "holdout_training_row_count={0.holdout_training_row_count}, "
            "holdout_training_start_date={0.holdout_training_start_date}, "
            "prediction_training_duration={0.prediction_training_duration}, "
            "prediction_training_end_date={0.prediction_training_end_date}, "
            "prediction_training_row_count={0.prediction_training_row_count}, "
            "prediction_training_start_date={0.prediction_training_start_date}, "
        ).format(self)
