#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.traning_prediction_explanation import TraningPredictionExplanation
from datarobot.models.full_api.generated.model.traning_prediction_shap_metadata import TraningPredictionShapMetadata
from datarobot.models.full_api.generated.model.traning_prediction_values import TraningPredictionValues

class TraningPredictionRow(APIObject):
    """
    Attributes
    ----------
    partition_id:str
         The partition used for the prediction record
    prediction:bool, date, datetime, dict, float, int, list, str, none_type
         The prediction of the model
    prediction_values:[TraningPredictionValues]
         A list of predicted values for this row. For regression problems the label will be the name of the target column or \"Anomaly score\". For classification problems the labels will be the names of the classes.
    row_id:str
         The row index of the prediction record
    forecast_distance:int, none_type [optional]
         (if time series project) How many time steps are between the forecastPoint and the timestamp. 
    forecast_point:str, none_type [optional]
         (if time series project) An ISO string repreesenting the point in time used as a basis to generate the predictions. 
    prediction_explanations:[TraningPredictionExplanation], none_type [optional]
         The prediction explanations for each feature. The total elements in the array are bounded by maxExplanations and feature count. Only present if prediction explanations were requested.. 
    series_id:str, none_type [optional]
         (if time series project) The ID of the series in a multiseries project. For a single series project this will be NaN. 
    shap_metadata:TraningPredictionShapMetadata [optional]
         
    timestamp:str, none_type [optional]
         (if datetime partitioned project) An ISO string representing the time of the prediction. 
    """
    _converter = t.Dict(
        {
            t.Key("partition_id"):  t.String(),
            t.Key("prediction"):  t.Any(),
            t.Key("prediction_values"):  t.List(t.Dict().allow_extra("*")),
            t.Key("row_id"):  t.String(),
            t.Key("forecast_distance", optional=True):  t.Int(),
            t.Key("forecast_point", optional=True):  t.String(),
            t.Key("prediction_explanations", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("series_id", optional=True):  t.String(),
            t.Key("shap_metadata", optional=True):  t.Any(),
            t.Key("timestamp", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        partition_id,
        prediction,
        prediction_values,
        row_id,
        forecast_distance=None,
        forecast_point=None,
        prediction_explanations=None,
        series_id=None,
        shap_metadata=None,
        timestamp=None,
    ):
        self.partition_id = partition_id
        self.prediction = prediction
        self.prediction_values = prediction_values
        self.row_id = row_id
        self.forecast_distance = forecast_distance
        self.forecast_point = forecast_point
        self.prediction_explanations = prediction_explanations
        self.series_id = series_id
        self.shap_metadata = shap_metadata
        self.timestamp = timestamp

    def __repr__(self):
        return (
            "TraningPredictionRow("
            "partition_id={0.partition_id}, "
            "prediction={0.prediction}, "
            "prediction_values={0.prediction_values}, "
            "row_id={0.row_id}, "
            "forecast_distance={0.forecast_distance}, "
            "forecast_point={0.forecast_point}, "
            "prediction_explanations={0.prediction_explanations}, "
            "series_id={0.series_id}, "
            "shap_metadata={0.shap_metadata}, "
            "timestamp={0.timestamp}, "
        ).format(self)
