#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.shap_warning_items import ShapWarningItems

class TraningPredictionShapMetadata(APIObject):
    """
    Attributes
    ----------
    shap_base_value:float
         The model's average prediction over the training data. SHAP values are deviations from the base value.
    shap_remaining_total:int
         The total of SHAP values for features beyond the maxExplanations. This can be identically 0 in all rows, if maxExplanations is greater than the number of features and thus all features are returned.
    warnings:[ShapWarningItems]
         SHAP values calculation warnings
    """
    _converter = t.Dict(
        {
            t.Key("shap_base_value"):  t.Float(),
            t.Key("shap_remaining_total"):  t.Int(),
            t.Key("warnings"):  t.List(t.Dict().allow_extra("*")),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        shap_base_value,
        shap_remaining_total,
        warnings,
    ):
        self.shap_base_value = shap_base_value
        self.shap_remaining_total = shap_remaining_total
        self.warnings = warnings

    def __repr__(self):
        return (
            "TraningPredictionShapMetadata("
            "shap_base_value={0.shap_base_value}, "
            "shap_remaining_total={0.shap_remaining_total}, "
            "warnings={0.warnings}, "
        ).format(self)
