#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.shap_warning import ShapWarning

class TraningPredictions(APIObject):
    """
    Attributes
    ----------
    data_subset:str
         Subset of data predicted on
    id:str
         ID of the training prediction job
    model_id:str
         ID of the model
    url:str
         The location of these predictions
    explanation_algorithm:str, none_type [optional]
         The method used for calculating prediction explanations.  if omitted the server will use the default value of "shap"
    max_explanations:int, none_type [optional]
         the number of top contributors that are included in prediction explanations. Defaults to null for datasets narrower than 100 columns, defaults to 100 for datasets wider than 100 columns. 
    shap_warnings:[ShapWarning], none_type [optional]
         Will be present if \"explanationAlgorithm\" was set to \"shap\" and there were additivity failures during SHAP values calculation. 
    """
    _converter = t.Dict(
        {
            t.Key("data_subset"):  t.String(),
            t.Key("id"):  t.String(),
            t.Key("model_id"):  t.String(),
            t.Key("url"):  t.String(),
            t.Key("explanation_algorithm", optional=True):  t.String(),
            t.Key("max_explanations", optional=True):  t.Int(),
            t.Key("shap_warnings", optional=True):  t.List(t.Dict().allow_extra("*")),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        data_subset,
        id,
        model_id,
        url,
        explanation_algorithm=None,
        max_explanations=None,
        shap_warnings=None,
    ):
        self.data_subset = data_subset
        self.id = id
        self.model_id = model_id
        self.url = url
        self.explanation_algorithm = explanation_algorithm
        self.max_explanations = max_explanations
        self.shap_warnings = shap_warnings

    def __repr__(self):
        return (
            "TraningPredictions("
            "data_subset={0.data_subset}, "
            "id={0.id}, "
            "model_id={0.model_id}, "
            "url={0.url}, "
            "explanation_algorithm={0.explanation_algorithm}, "
            "max_explanations={0.max_explanations}, "
            "shap_warnings={0.shap_warnings}, "
        ).format(self)
