#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.transformation_param import TransformationParam

class Transformation(APIObject):
    """
    Attributes
    ----------
    name:str
         Transformation name
    enabled:bool [optional]
         Whether this transformation is enabled by default.  if omitted the server will use the default value of False
    params:[TransformationParam] [optional]
         Config values for transformation. 
    """
    _converter = t.Dict(
        {
            t.Key("name"):  t.String(),
            t.Key("enabled", optional=True):  t.Bool(),
            t.Key("params", optional=True):  t.List(t.Dict().allow_extra("*")),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        name,
        enabled=None,
        params=None,
    ):
        self.name = name
        self.enabled = enabled
        self.params = params

    def __repr__(self):
        return (
            "Transformation("
            "name={0.name}, "
            "enabled={0.enabled}, "
            "params={0.params}, "
        ).format(self)
