#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.constraints import Constraints

class TuningParameters(APIObject):
    """
    Attributes
    ----------
    constraints:Constraints
        
    current_value:bool, date, datetime, dict, float, int, list, str, none_type
         Value of this parameter used by the current model.
    default_value:bool, date, datetime, dict, float, int, list, str, none_type
         Default value of this parameter.
    parameter_id:str
         Unique (per-blueprint) identifier of this parameter. This is the identifier used to specify which parameter to tune when make a new advanced tuning request.
    parameter_name:str
         Name of the parameter.
    task_name:str
         Human-readable name of the task that this parameter belongs to.
    """
    _converter = t.Dict(
        {
            t.Key("constraints"):  t.Any(),
            t.Key("current_value"):  t.Any(),
            t.Key("default_value"):  t.Any(),
            t.Key("parameter_id"):  t.String(),
            t.Key("parameter_name"):  t.String(),
            t.Key("task_name"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        constraints,
        current_value,
        default_value,
        parameter_id,
        parameter_name,
        task_name,
    ):
        self.constraints = constraints
        self.current_value = current_value
        self.default_value = default_value
        self.parameter_id = parameter_id
        self.parameter_name = parameter_name
        self.task_name = task_name

    def __repr__(self):
        return (
            "TuningParameters("
            "constraints={0.constraints}, "
            "current_value={0.current_value}, "
            "default_value={0.default_value}, "
            "parameter_id={0.parameter_id}, "
            "parameter_name={0.parameter_name}, "
            "task_name={0.task_name}, "
        ).format(self)
