#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class UpdateCatalogMetadata(APIObject):
    """
    Attributes
    ----------
    description:str [optional]
         New catalog item description. 
    name:str [optional]
         New catalog item name. 
    tags:[str] [optional]
         New catalog item tags. Tags must be the lower case, without spaces,and cannot include -$.,{}\"#' special characters.. 
    """
    _converter = t.Dict(
        {
            t.Key("description", optional=True):  t.String(),
            t.Key("name", optional=True):  t.String(),
            t.Key("tags", optional=True):  t.List(t.Dict().allow_extra("*")),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        description=None,
        name=None,
        tags=None,
    ):
        self.description = description
        self.name = name
        self.tags = tags

    def __repr__(self):
        return (
            "UpdateCatalogMetadata("
            "description={0.description}, "
            "name={0.name}, "
            "tags={0.tags}, "
        ).format(self)
