#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class UpdateDriverRequest(APIObject):
    """
    Attributes
    ----------
    base_names:[str] [optional]
         Original file name(s) of the uploaded JAR file(s). If there are multiple JAR files required for the driver, each of the original file names should be present in the list in the same order as found in 'localJarUrls'. 
    canonical_name:str [optional]
         User-friendly driver name.. 
    class_name:str [optional]
         Driver class name. For example 'com.amazon.redshift.jdbc.Driver'). 
    configuration_id:str, none_type [optional]
         Driver configuration ID if it was provided during driver upload.. 
    local_jar_urls:[str] [optional]
         File path(s) for the driver files.This path is returned in the response as 'local_url' by the driverUpload route.If there are multiple JAR files required for the driver, each uploaded JAR must be present in this list. If specified, values will replace any previous settings.. 
    remove_config:bool [optional]
         Pass `True` to remove configuration currently associated with this driver. Note: must pass `canonicalName` and `className` if removing the configuration.. 
    skip_config_verification:bool [optional]
         Pass `True` to skip `jdbc_url` verification.. 
    version:str [optional]
         Driver version, which is used to construct the canonical name if driver configuration ID was provided during driver upload.. 
    """
    _converter = t.Dict(
        {
            t.Key("base_names", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("canonical_name", optional=True):  t.String(),
            t.Key("class_name", optional=True):  t.String(),
            t.Key("configuration_id", optional=True):  t.String(),
            t.Key("local_jar_urls", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("remove_config", optional=True):  t.Bool(),
            t.Key("skip_config_verification", optional=True):  t.Bool(),
            t.Key("version", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        base_names=None,
        canonical_name=None,
        class_name=None,
        configuration_id=None,
        local_jar_urls=None,
        remove_config=None,
        skip_config_verification=None,
        version=None,
    ):
        self.base_names = base_names
        self.canonical_name = canonical_name
        self.class_name = class_name
        self.configuration_id = configuration_id
        self.local_jar_urls = local_jar_urls
        self.remove_config = remove_config
        self.skip_config_verification = skip_config_verification
        self.version = version

    def __repr__(self):
        return (
            "UpdateDriverRequest("
            "base_names={0.base_names}, "
            "canonical_name={0.canonical_name}, "
            "class_name={0.class_name}, "
            "configuration_id={0.configuration_id}, "
            "local_jar_urls={0.local_jar_urls}, "
            "remove_config={0.remove_config}, "
            "skip_config_verification={0.skip_config_verification}, "
            "version={0.version}, "
        ).format(self)
