#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.saml_advanced_configuration import SamlAdvancedConfiguration
from datarobot.models.full_api.generated.model.saml_attribute_mapping import SamlAttributeMapping
from datarobot.models.full_api.generated.model.saml_certificate import SamlCertificate
from datarobot.models.full_api.generated.model.saml_group_mapping import SamlGroupMapping
from datarobot.models.full_api.generated.model.saml_metadata_file import SamlMetadataFile
from datarobot.models.full_api.generated.model.saml_role_mapping import SamlRoleMapping
from datarobot.models.full_api.generated.model.saml_security_parameters import SamlSecurityParameters

class UpdateSsoConfiguration(APIObject):
    """
    Attributes
    ----------
    advanced_configuration:SamlAdvancedConfiguration [optional]
         
    attribute_mapping:SamlAttributeMapping [optional]
         
    auto_generate_users:bool [optional]
         determines if DataRobot automatically creates an account on first successful login via IdP if the user doesn't exist in the DataRobot application.. 
    certificate:SamlCertificate [optional]
         
    configuration_type:str [optional]
         The type of the SSO configuration, defines the source of SSO metadata. It can be one of the following: `METADATA` - when IDP metadata is provided in the config, `METADATA_URL` - when an URL for metadata retrieval is provided in the config and `MANUAL` - when IDP sign-on/sign-out URLs and certificate are provided.. 
    enable_sso:bool [optional]
         Defines if SSO is enabled.. 
    enforce_sso:bool [optional]
         Defines if SSO is enforced.. 
    entity_id:str [optional]
         The globally unique identifier of the entity. Provided by IdP service.. 
    group_mapping:[SamlGroupMapping] [optional]
         The list of DataRobot group to identity provider group maps.. 
    idp_metadata:SamlMetadataFile [optional]
         
    idp_metadata_https_verify:bool [optional]
         When idp_metadata_url uses HTTPS, require the server to have a trusted certificate. To avoid security vulnerabilities, only set to False when a trusted server has a self-signed certificate.. 
    idp_metadata_url:str [optional]
         URL to the IdP SSO descriptor. Provided by IdP service.. 
    idp_response_method:str [optional]
         Identity provider response method, used to move user from IdP's authentication form back to the DataRobot side.. 
    issuer:str [optional]
         Optional Issuer field that may be required by IdP.. 
    name:str [optional]
         The name of the SSO configuration.. 
    organization_id:str [optional]
         The organization ID to which the SSO config belongs.. 
    role_mapping:[SamlRoleMapping] [optional]
         The list of DataRobot access role to identity provider role maps.. 
    security_parameters:SamlSecurityParameters [optional]
         
    session_length_seconds:int [optional]
         Time window for the authentication session via IdP.. 
    sign_on_url:str [optional]
         URL to sign on via SSO.. 
    sign_out_url:str [optional]
         URL to sign out via SSO.. 
    sp_request_method:str [optional]
         Service provider (DataRobot application) request method, is used to move user to the IdP's authentication form.. 
    """
    _converter = t.Dict(
        {
            t.Key("advanced_configuration", optional=True):  t.Any(),
            t.Key("attribute_mapping", optional=True):  t.Any(),
            t.Key("auto_generate_users", optional=True):  t.Bool(),
            t.Key("certificate", optional=True):  t.Any(),
            t.Key("configuration_type", optional=True):  t.String(),
            t.Key("enable_sso", optional=True):  t.Bool(),
            t.Key("enforce_sso", optional=True):  t.Bool(),
            t.Key("entity_id", optional=True):  t.String(),
            t.Key("group_mapping", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("idp_metadata", optional=True):  t.Any(),
            t.Key("idp_metadata_https_verify", optional=True):  t.Bool(),
            t.Key("idp_metadata_url", optional=True):  t.String(),
            t.Key("idp_response_method", optional=True):  t.String(),
            t.Key("issuer", optional=True):  t.String(),
            t.Key("name", optional=True):  t.String(),
            t.Key("organization_id", optional=True):  t.String(),
            t.Key("role_mapping", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("security_parameters", optional=True):  t.Any(),
            t.Key("session_length_seconds", optional=True):  t.Int(),
            t.Key("sign_on_url", optional=True):  t.String(),
            t.Key("sign_out_url", optional=True):  t.String(),
            t.Key("sp_request_method", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        advanced_configuration=None,
        attribute_mapping=None,
        auto_generate_users=None,
        certificate=None,
        configuration_type=None,
        enable_sso=None,
        enforce_sso=None,
        entity_id=None,
        group_mapping=None,
        idp_metadata=None,
        idp_metadata_https_verify=None,
        idp_metadata_url=None,
        idp_response_method=None,
        issuer=None,
        name=None,
        organization_id=None,
        role_mapping=None,
        security_parameters=None,
        session_length_seconds=None,
        sign_on_url=None,
        sign_out_url=None,
        sp_request_method=None,
    ):
        self.advanced_configuration = advanced_configuration
        self.attribute_mapping = attribute_mapping
        self.auto_generate_users = auto_generate_users
        self.certificate = certificate
        self.configuration_type = configuration_type
        self.enable_sso = enable_sso
        self.enforce_sso = enforce_sso
        self.entity_id = entity_id
        self.group_mapping = group_mapping
        self.idp_metadata = idp_metadata
        self.idp_metadata_https_verify = idp_metadata_https_verify
        self.idp_metadata_url = idp_metadata_url
        self.idp_response_method = idp_response_method
        self.issuer = issuer
        self.name = name
        self.organization_id = organization_id
        self.role_mapping = role_mapping
        self.security_parameters = security_parameters
        self.session_length_seconds = session_length_seconds
        self.sign_on_url = sign_on_url
        self.sign_out_url = sign_out_url
        self.sp_request_method = sp_request_method

    def __repr__(self):
        return (
            "UpdateSsoConfiguration("
            "advanced_configuration={0.advanced_configuration}, "
            "attribute_mapping={0.attribute_mapping}, "
            "auto_generate_users={0.auto_generate_users}, "
            "certificate={0.certificate}, "
            "configuration_type={0.configuration_type}, "
            "enable_sso={0.enable_sso}, "
            "enforce_sso={0.enforce_sso}, "
            "entity_id={0.entity_id}, "
            "group_mapping={0.group_mapping}, "
            "idp_metadata={0.idp_metadata}, "
            "idp_metadata_https_verify={0.idp_metadata_https_verify}, "
            "idp_metadata_url={0.idp_metadata_url}, "
            "idp_response_method={0.idp_response_method}, "
            "issuer={0.issuer}, "
            "name={0.name}, "
            "organization_id={0.organization_id}, "
            "role_mapping={0.role_mapping}, "
            "security_parameters={0.security_parameters}, "
            "session_length_seconds={0.session_length_seconds}, "
            "sign_on_url={0.sign_on_url}, "
            "sign_out_url={0.sign_out_url}, "
            "sp_request_method={0.sp_request_method}, "
        ).format(self)
