#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class Url(APIObject):
    """
    Attributes
    ----------
    url:str
         The URL to download the dataset used to create the dataset item and version.
    categories:bool, date, datetime, dict, float, int, list, str, none_type [optional]
         An array of strings describing the intended use of the dataset.. 
    do_snapshot:bool [optional]
         If true, create a snapshot dataset; if false, create a remote dataset. Creating snapshots from non-file sources requires an additional permission, `Enable Create Snapshot Data Source`..  if omitted the server will use the default value of True
    persist_data_after_ingestion:bool [optional]
         If true, will enforce saving all data (for download and sampling) and will allow a user to view extended data profile (which includes data statistics like min/max/median/mean, histogram, etc.). If false, will not enforce saving data. The data schema (feature names and types) still will be available. Specifying this parameter to false and `doSnapshot` to true will result in an error.. 
    """
    _converter = t.Dict(
        {
            t.Key("url"):  t.String(),
            t.Key("categories", optional=True):  t.Any(),
            t.Key("do_snapshot", optional=True):  t.Bool(),
            t.Key("persist_data_after_ingestion", optional=True):  t.Bool(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        url,
        categories=None,
        do_snapshot=None,
        persist_data_after_ingestion=None,
    ):
        self.url = url
        self.categories = categories
        self.do_snapshot = do_snapshot
        self.persist_data_after_ingestion = persist_data_after_ingestion

    def __repr__(self):
        return (
            "Url("
            "url={0.url}, "
            "categories={0.categories}, "
            "do_snapshot={0.do_snapshot}, "
            "persist_data_after_ingestion={0.persist_data_after_ingestion}, "
        ).format(self)
