#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class UsageDataExport(APIObject):
    """
    Attributes
    ----------
    include_identifying_fields:bool
         Indicates if identifying information like user names, project names, etc. should be included or not. Defaults to True.. defaults to True
    end:datetime, none_type [optional]
         The upper bound of stored events timestamp to include within the artifact.. 
    include:[str] [optional]
         Additional fields to be included.. 
    include_report:[str], none_type [optional]
         The list of reports that should be generated. Will default to `None` if not specified.. 
    no_cache:bool [optional]
         Switches off caching.. 
    project_id:str [optional]
         Only actions that are connected with the project will be retrieved.. 
    start:datetime, none_type [optional]
         The lower bound of stored events timestamp to include within the artifact.. 
    user_id:str [optional]
         Only actions performed by this user will be retrieved.. 
    """
    _converter = t.Dict(
        {
            t.Key("include_identifying_fields"):  t.Bool(),
            t.Key("end", optional=True):  t.DateTime(),
            t.Key("include", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("include_report", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("no_cache", optional=True):  t.Bool(),
            t.Key("project_id", optional=True):  t.String(),
            t.Key("start", optional=True):  t.DateTime(),
            t.Key("user_id", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        include_identifying_fields,
        end=None,
        include=None,
        include_report=None,
        no_cache=None,
        project_id=None,
        start=None,
        user_id=None,
    ):
        self.include_identifying_fields = include_identifying_fields
        self.end = end
        self.include = include
        self.include_report = include_report
        self.no_cache = no_cache
        self.project_id = project_id
        self.start = start
        self.user_id = user_id

    def __repr__(self):
        return (
            "UsageDataExport("
            "include_identifying_fields={0.include_identifying_fields}, "
            "end={0.end}, "
            "include={0.include}, "
            "include_report={0.include_report}, "
            "no_cache={0.no_cache}, "
            "project_id={0.project_id}, "
            "start={0.start}, "
            "user_id={0.user_id}, "
        ).format(self)
