#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.dr_user_id import DrUserId
from datarobot.models.full_api.generated.model.monetary_value import MonetaryValue
from datarobot.models.full_api.generated.model.target_date import TargetDate

class UseCase(APIObject):
    """
    Attributes
    ----------
    name:str
         Name of the use case
    business_impact:int, none_type [optional]
         Expected effects on overall business operations. 
    comment_id:str [optional]
         The id for this comment. 
    content:str [optional]
         A string. 
    description:str [optional]
         Use case description. 
    feasibility:int, none_type [optional]
         Assessment of how the use case can be accomplished across multiple dimensions. 
    id:str, none_type [optional]
         The id of this description item. 
    mentions:[DrUserId] [optional]
         A list of user objects. 
    notes:str, none_type [optional]
         User notes. 
    owner:DrUserId [optional]
         
    permissions:[str], none_type [optional]
         Permissions of current user. 
    potential_value:MonetaryValue [optional]
         
    potential_value_template:bool, date, datetime, dict, float, int, list, str, none_type [optional]
         Optional, Contains Template type and parameter information. 
    prediction_targets:[str] [optional]
         An array of strings prediction target names. 
    realized_value:bool, date, datetime, dict, float, int, list, str, none_type [optional]
         Optional, Contains MonetaryValue objects. 
    stage:str [optional]
         Current stage of use case. 
    target_dates:[TargetDate] [optional]
         Array of TargetDate objects. 
    """
    _converter = t.Dict(
        {
            t.Key("name"):  t.String(),
            t.Key("business_impact", optional=True):  t.Int(),
            t.Key("comment_id", optional=True):  t.String(),
            t.Key("content", optional=True):  t.String(),
            t.Key("description", optional=True):  t.String(),
            t.Key("feasibility", optional=True):  t.Int(),
            t.Key("id", optional=True):  t.String(),
            t.Key("mentions", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("notes", optional=True):  t.String(),
            t.Key("owner", optional=True):  t.Any(),
            t.Key("permissions", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("potential_value", optional=True):  t.Any(),
            t.Key("potential_value_template", optional=True):  t.Any(),
            t.Key("prediction_targets", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("realized_value", optional=True):  t.Any(),
            t.Key("stage", optional=True):  t.String(),
            t.Key("target_dates", optional=True):  t.List(t.Dict().allow_extra("*")),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        name,
        business_impact=None,
        comment_id=None,
        content=None,
        description=None,
        feasibility=None,
        id=None,
        mentions=None,
        notes=None,
        owner=None,
        permissions=None,
        potential_value=None,
        potential_value_template=None,
        prediction_targets=None,
        realized_value=None,
        stage=None,
        target_dates=None,
    ):
        self.name = name
        self.business_impact = business_impact
        self.comment_id = comment_id
        self.content = content
        self.description = description
        self.feasibility = feasibility
        self.id = id
        self.mentions = mentions
        self.notes = notes
        self.owner = owner
        self.permissions = permissions
        self.potential_value = potential_value
        self.potential_value_template = potential_value_template
        self.prediction_targets = prediction_targets
        self.realized_value = realized_value
        self.stage = stage
        self.target_dates = target_dates

    def __repr__(self):
        return (
            "UseCase("
            "name={0.name}, "
            "business_impact={0.business_impact}, "
            "comment_id={0.comment_id}, "
            "content={0.content}, "
            "description={0.description}, "
            "feasibility={0.feasibility}, "
            "id={0.id}, "
            "mentions={0.mentions}, "
            "notes={0.notes}, "
            "owner={0.owner}, "
            "permissions={0.permissions}, "
            "potential_value={0.potential_value}, "
            "potential_value_template={0.potential_value_template}, "
            "prediction_targets={0.prediction_targets}, "
            "realized_value={0.realized_value}, "
            "stage={0.stage}, "
            "target_dates={0.target_dates}, "
        ).format(self)
