#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.dr_user_id import DrUserId
from datarobot.models.full_api.generated.model.event_descriptions import EventDescriptions

class UseCaseActivity(APIObject):
    """
    Attributes
    ----------
    event_description:EventDescriptions
        
    event_type:str, none_type
         The type of activity
    timestamp:datetime
         The timestamp of the activity
    user:DrUserId
        
    first_name:str, none_type [optional]
         First name of use case owner. 
    id:str [optional]
         The id of the use case activity. 
    last_name:str, none_type [optional]
         Last of use case owner. 
    username:str [optional]
         Username of use case owner. 
    """
    _converter = t.Dict(
        {
            t.Key("event_description"):  t.Any(),
            t.Key("event_type"):  t.String(),
            t.Key("timestamp"):  t.DateTime(),
            t.Key("user"):  t.Any(),
            t.Key("first_name", optional=True):  t.String(),
            t.Key("id", optional=True):  t.String(),
            t.Key("last_name", optional=True):  t.String(),
            t.Key("username", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        event_description,
        event_type,
        timestamp,
        user,
        first_name=None,
        id=None,
        last_name=None,
        username=None,
    ):
        self.event_description = event_description
        self.event_type = event_type
        self.timestamp = timestamp
        self.user = user
        self.first_name = first_name
        self.id = id
        self.last_name = last_name
        self.username = username

    def __repr__(self):
        return (
            "UseCaseActivity("
            "event_description={0.event_description}, "
            "event_type={0.event_type}, "
            "timestamp={0.timestamp}, "
            "user={0.user}, "
            "first_name={0.first_name}, "
            "id={0.id}, "
            "last_name={0.last_name}, "
            "username={0.username}, "
        ).format(self)
