#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class UseCaseAttachmentApplicationOverview(APIObject):
    """
    Attributes
    ----------
    app_type:str
         Type of the application
    created_at:datetime
         Time when application was created
    last_modified_at:datetime
         Time of the last modification
    name:str
         Name of the application
    version:str
         Version string of the app
    """
    _converter = t.Dict(
        {
            t.Key("app_type"):  t.String(),
            t.Key("created_at"):  t.DateTime(),
            t.Key("last_modified_at"):  t.DateTime(),
            t.Key("name"):  t.String(),
            t.Key("version"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        app_type,
        created_at,
        last_modified_at,
        name,
        version,
    ):
        self.app_type = app_type
        self.created_at = created_at
        self.last_modified_at = last_modified_at
        self.name = name
        self.version = version

    def __repr__(self):
        return (
            "UseCaseAttachmentApplicationOverview("
            "app_type={0.app_type}, "
            "created_at={0.created_at}, "
            "last_modified_at={0.last_modified_at}, "
            "name={0.name}, "
            "version={0.version}, "
        ).format(self)
