#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class UseCaseAttachmentDatasetOverview(APIObject):
    """
    Attributes
    ----------
    created_at:datetime
         Time when dataset was created
    created_by:str
         Name of user who created the dataset
    last_modified_at:datetime
         Time of the last modification
    last_modified_by:str
         Name of user who did last modification
    name:str
         Name of the dataset
    """
    _converter = t.Dict(
        {
            t.Key("created_at"):  t.DateTime(),
            t.Key("created_by"):  t.String(),
            t.Key("last_modified_at"):  t.DateTime(),
            t.Key("last_modified_by"):  t.String(),
            t.Key("name"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        created_at,
        created_by,
        last_modified_at,
        last_modified_by,
        name,
    ):
        self.created_at = created_at
        self.created_by = created_by
        self.last_modified_at = last_modified_at
        self.last_modified_by = last_modified_by
        self.name = name

    def __repr__(self):
        return (
            "UseCaseAttachmentDatasetOverview("
            "created_at={0.created_at}, "
            "created_by={0.created_by}, "
            "last_modified_at={0.last_modified_at}, "
            "last_modified_by={0.last_modified_by}, "
            "name={0.name}, "
        ).format(self)
