#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.use_case_attachment_deployment_health import UseCaseAttachmentDeploymentHealth
from datarobot.models.full_api.generated.model.use_case_attachment_deployment_prediction_usage import UseCaseAttachmentDeploymentPredictionUsage

class UseCaseAttachmentDeploymentOverview(APIObject):
    """
    Attributes
    ----------
    accuracy_health:UseCaseAttachmentDeploymentHealth
        
    model_health:UseCaseAttachmentDeploymentHealth
        
    name:str
         Name of the deployment
    prediction_server:str
         Name of prediction server
    prediction_usage:UseCaseAttachmentDeploymentPredictionUsage
        
    service_health:UseCaseAttachmentDeploymentHealth
        
    """
    _converter = t.Dict(
        {
            t.Key("accuracy_health"):  t.Any(),
            t.Key("model_health"):  t.Any(),
            t.Key("name"):  t.String(),
            t.Key("prediction_server"):  t.String(),
            t.Key("prediction_usage"):  t.Any(),
            t.Key("service_health"):  t.Any(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        accuracy_health,
        model_health,
        name,
        prediction_server,
        prediction_usage,
        service_health,
    ):
        self.accuracy_health = accuracy_health
        self.model_health = model_health
        self.name = name
        self.prediction_server = prediction_server
        self.prediction_usage = prediction_usage
        self.service_health = service_health

    def __repr__(self):
        return (
            "UseCaseAttachmentDeploymentOverview("
            "accuracy_health={0.accuracy_health}, "
            "model_health={0.model_health}, "
            "name={0.name}, "
            "prediction_server={0.prediction_server}, "
            "prediction_usage={0.prediction_usage}, "
            "service_health={0.service_health}, "
        ).format(self)
