#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class UseCaseAttachmentModelPackageOverview(APIObject):
    """
    Attributes
    ----------
    created_at:datetime
         Time when model package was created
    deployment_count:int
         Number of deployments
    execution_type:str
         Type of execution
    name:str
         Name of the model package
    target_name:str
         Name of modeling target
    target_type:str
         Type of modeling target
    """
    _converter = t.Dict(
        {
            t.Key("created_at"):  t.DateTime(),
            t.Key("deployment_count"):  t.Int(),
            t.Key("execution_type"):  t.String(),
            t.Key("name"):  t.String(),
            t.Key("target_name"):  t.String(),
            t.Key("target_type"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        created_at,
        deployment_count,
        execution_type,
        name,
        target_name,
        target_type,
    ):
        self.created_at = created_at
        self.deployment_count = deployment_count
        self.execution_type = execution_type
        self.name = name
        self.target_name = target_name
        self.target_type = target_type

    def __repr__(self):
        return (
            "UseCaseAttachmentModelPackageOverview("
            "created_at={0.created_at}, "
            "deployment_count={0.deployment_count}, "
            "execution_type={0.execution_type}, "
            "name={0.name}, "
            "target_name={0.target_name}, "
            "target_type={0.target_type}, "
        ).format(self)
