#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class UseCaseAttachmentModelingProjectOverview(APIObject):
    """
    Attributes
    ----------
    created_at:datetime
         Time when project was created
    dataset_name:str
         Name of default dataset
    name:str
         Name of the project
    number_of_models:int, none_type
         Number of the models in the project
    owner:str, none_type
         Name of the modeling project owner
    target_name:str
         Name of modeling target
    """
    _converter = t.Dict(
        {
            t.Key("created_at"):  t.DateTime(),
            t.Key("dataset_name"):  t.String(),
            t.Key("name"):  t.String(),
            t.Key("number_of_models"):  t.Int(),
            t.Key("owner"):  t.String(),
            t.Key("target_name"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        created_at,
        dataset_name,
        name,
        number_of_models,
        owner,
        target_name,
    ):
        self.created_at = created_at
        self.dataset_name = dataset_name
        self.name = name
        self.number_of_models = number_of_models
        self.owner = owner
        self.target_name = target_name

    def __repr__(self):
        return (
            "UseCaseAttachmentModelingProjectOverview("
            "created_at={0.created_at}, "
            "dataset_name={0.dataset_name}, "
            "name={0.name}, "
            "number_of_models={0.number_of_models}, "
            "owner={0.owner}, "
            "target_name={0.target_name}, "
        ).format(self)
