#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class UseCaseAttachmentResponse(APIObject):
    """
    Attributes
    ----------
    attached_object_id:str
         The id of the attached object
    can_view:bool
         Indicates if user has view access to the attached object
    id:str
         The id of the use case
    is_access_requested:bool
         Indicates if user has requested access to the attached object
    overview:bool, date, datetime, dict, float, int, list, str, none_type
         Detailed information depending on the type of the attachment
    type:str
         Use case attachment type
    use_case_id:str
         The id of the use case
    """
    _converter = t.Dict(
        {
            t.Key("attached_object_id"):  t.String(),
            t.Key("can_view"):  t.Bool(),
            t.Key("id"):  t.String(),
            t.Key("is_access_requested"):  t.Bool(),
            t.Key("overview"):  t.Any(),
            t.Key("type"):  t.String(),
            t.Key("use_case_id"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        attached_object_id,
        can_view,
        id,
        is_access_requested,
        overview,
        type,
        use_case_id,
    ):
        self.attached_object_id = attached_object_id
        self.can_view = can_view
        self.id = id
        self.is_access_requested = is_access_requested
        self.overview = overview
        self.type = type
        self.use_case_id = use_case_id

    def __repr__(self):
        return (
            "UseCaseAttachmentResponse("
            "attached_object_id={0.attached_object_id}, "
            "can_view={0.can_view}, "
            "id={0.id}, "
            "is_access_requested={0.is_access_requested}, "
            "overview={0.overview}, "
            "type={0.type}, "
            "use_case_id={0.use_case_id}, "
        ).format(self)
