#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.use_case_bucket_period import UseCaseBucketPeriod

class UseCaseBucket(APIObject):
    """
    Attributes
    ----------
    period:UseCaseBucketPeriod
        
    predictions_count:int
         Total number of predictions that happened in this bucket
    realized_value:int [optional]
         Total amount of value realised during this bucket. 
    """
    _converter = t.Dict(
        {
            t.Key("period"):  t.Any(),
            t.Key("predictions_count"):  t.Int(),
            t.Key("realized_value", optional=True):  t.Int(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        period,
        predictions_count,
        realized_value=None,
    ):
        self.period = period
        self.predictions_count = predictions_count
        self.realized_value = realized_value

    def __repr__(self):
        return (
            "UseCaseBucket("
            "period={0.period}, "
            "predictions_count={0.predictions_count}, "
            "realized_value={0.realized_value}, "
        ).format(self)
