#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.dr_user_id import DrUserId
from datarobot.models.full_api.generated.model.monetary_value import MonetaryValue
from datarobot.models.full_api.generated.model.target_date import TargetDate

class UseCaseCreateResponse(APIObject):
    """
    Attributes
    ----------
    accuracy_health:bool, date, datetime, dict, float, int, list, str, none_type [optional]
         The health of the accuracy. 
    business_impact:int, none_type [optional]
         Expected effects on overall business operations. 
    comment_id:str [optional]
         The id for this comment. 
    content:str [optional]
         A string. 
    description:str [optional]
         Use case description. 
    feasibility:int, none_type [optional]
         Assessment of how the use case can be accomplished across multiple dimensions. 
    id:str [optional]
         The id of the use case. 
    in_production_warning:str, none_type [optional]
         An optional warning to indicate that deployments are attached to this use case.. 
    mentions:[DrUserId] [optional]
         A list of user objects. 
    model_health:bool, date, datetime, dict, float, int, list, str, none_type [optional]
         The health of the model. 
    name:str [optional]
         Name of the use case. 
    notes:str, none_type [optional]
         User notes. 
    owner:DrUserId [optional]
         
    permissions:[str], none_type [optional]
         Permissions of current user. 
    potential_value:MonetaryValue [optional]
         
    potential_value_template:bool, date, datetime, dict, float, int, list, str, none_type [optional]
         Optional, Contains Template type and parameter information. 
    prediction_targets:[str] [optional]
         An array of strings prediction target names. 
    predictions_count:bool, date, datetime, dict, float, int, list, str, none_type [optional]
         Count of the number of predictions made.. 
    realized_value:bool, date, datetime, dict, float, int, list, str, none_type [optional]
         Optional, Contains MonetaryValue objects. 
    service_health:bool, date, datetime, dict, float, int, list, str, none_type [optional]
         The health of the service. 
    stage:str [optional]
         Current stage of use case. 
    target_dates:[TargetDate], none_type [optional]
         Array of TargetDate objects. 
    """
    _converter = t.Dict(
        {
            t.Key("accuracy_health", optional=True):  t.Any(),
            t.Key("business_impact", optional=True):  t.Int(),
            t.Key("comment_id", optional=True):  t.String(),
            t.Key("content", optional=True):  t.String(),
            t.Key("description", optional=True):  t.String(),
            t.Key("feasibility", optional=True):  t.Int(),
            t.Key("id", optional=True):  t.String(),
            t.Key("in_production_warning", optional=True):  t.String(),
            t.Key("mentions", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("model_health", optional=True):  t.Any(),
            t.Key("name", optional=True):  t.String(),
            t.Key("notes", optional=True):  t.String(),
            t.Key("owner", optional=True):  t.Any(),
            t.Key("permissions", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("potential_value", optional=True):  t.Any(),
            t.Key("potential_value_template", optional=True):  t.Any(),
            t.Key("prediction_targets", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("predictions_count", optional=True):  t.Any(),
            t.Key("realized_value", optional=True):  t.Any(),
            t.Key("service_health", optional=True):  t.Any(),
            t.Key("stage", optional=True):  t.String(),
            t.Key("target_dates", optional=True):  t.List(t.Dict().allow_extra("*")),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        accuracy_health=None,
        business_impact=None,
        comment_id=None,
        content=None,
        description=None,
        feasibility=None,
        id=None,
        in_production_warning=None,
        mentions=None,
        model_health=None,
        name=None,
        notes=None,
        owner=None,
        permissions=None,
        potential_value=None,
        potential_value_template=None,
        prediction_targets=None,
        predictions_count=None,
        realized_value=None,
        service_health=None,
        stage=None,
        target_dates=None,
    ):
        self.accuracy_health = accuracy_health
        self.business_impact = business_impact
        self.comment_id = comment_id
        self.content = content
        self.description = description
        self.feasibility = feasibility
        self.id = id
        self.in_production_warning = in_production_warning
        self.mentions = mentions
        self.model_health = model_health
        self.name = name
        self.notes = notes
        self.owner = owner
        self.permissions = permissions
        self.potential_value = potential_value
        self.potential_value_template = potential_value_template
        self.prediction_targets = prediction_targets
        self.predictions_count = predictions_count
        self.realized_value = realized_value
        self.service_health = service_health
        self.stage = stage
        self.target_dates = target_dates

    def __repr__(self):
        return (
            "UseCaseCreateResponse("
            "accuracy_health={0.accuracy_health}, "
            "business_impact={0.business_impact}, "
            "comment_id={0.comment_id}, "
            "content={0.content}, "
            "description={0.description}, "
            "feasibility={0.feasibility}, "
            "id={0.id}, "
            "in_production_warning={0.in_production_warning}, "
            "mentions={0.mentions}, "
            "model_health={0.model_health}, "
            "name={0.name}, "
            "notes={0.notes}, "
            "owner={0.owner}, "
            "permissions={0.permissions}, "
            "potential_value={0.potential_value}, "
            "potential_value_template={0.potential_value_template}, "
            "prediction_targets={0.prediction_targets}, "
            "predictions_count={0.predictions_count}, "
            "realized_value={0.realized_value}, "
            "service_health={0.service_health}, "
            "stage={0.stage}, "
            "target_dates={0.target_dates}, "
        ).format(self)
