#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.use_case_bucket_period import UseCaseBucketPeriod

class UseCaseSummary(APIObject):
    """
    Attributes
    ----------
    average_predictions_count:int
         Average number of predictions per bucket during this time period
    period:UseCaseBucketPeriod
        
    total_realized_value:int
         Total amount of value realised during this time period
    average_realized_value:int [optional]
         Average amount of value per bucket realised during this time period. 
    total_predictions_count:int [optional]
         Total number of predictions that happened during this time period. 
    """
    _converter = t.Dict(
        {
            t.Key("average_predictions_count"):  t.Int(),
            t.Key("period"):  t.Any(),
            t.Key("total_realized_value"):  t.Int(),
            t.Key("average_realized_value", optional=True):  t.Int(),
            t.Key("total_predictions_count", optional=True):  t.Int(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        average_predictions_count,
        period,
        total_realized_value,
        average_realized_value=None,
        total_predictions_count=None,
    ):
        self.average_predictions_count = average_predictions_count
        self.period = period
        self.total_realized_value = total_realized_value
        self.average_realized_value = average_realized_value
        self.total_predictions_count = total_predictions_count

    def __repr__(self):
        return (
            "UseCaseSummary("
            "average_predictions_count={0.average_predictions_count}, "
            "period={0.period}, "
            "total_realized_value={0.total_realized_value}, "
            "average_realized_value={0.average_realized_value}, "
            "total_predictions_count={0.total_predictions_count}, "
        ).format(self)
