#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.dr_user_id import DrUserId
from datarobot.models.full_api.generated.model.monetary_value import MonetaryValue
from datarobot.models.full_api.generated.model.target_date import TargetDate

class UseCaseUpdate(APIObject):
    """
    Attributes
    ----------
    business_impact:int, none_type [optional]
         Expected effects on overall business operations. 
    description:str, none_type [optional]
         Use case description. 
    feasibility:int, none_type [optional]
         Assessment of how the use case can be accomplished across multiple dimensions. 
    name:str [optional]
         Name of the use case. 
    notes:str, none_type [optional]
         User notes. 
    owner:DrUserId [optional]
         
    potential_value:MonetaryValue [optional]
         
    potential_value_template:bool, date, datetime, dict, float, int, list, str, none_type [optional]
         Contains Template type and parameter information defined in the response of :http:get:`/api/v2/useCaseValueTemplates/(templateType)/calculation/`. 
    prediction_targets:[str], none_type [optional]
         An array of strings prediction target names. 
    realized_value:MonetaryValue [optional]
         
    stage:str [optional]
         Current stage of use case. 
    target_dates:[TargetDate], none_type [optional]
         Array of TargetDate objects. 
    """
    _converter = t.Dict(
        {
            t.Key("business_impact", optional=True):  t.Int(),
            t.Key("description", optional=True):  t.String(),
            t.Key("feasibility", optional=True):  t.Int(),
            t.Key("name", optional=True):  t.String(),
            t.Key("notes", optional=True):  t.String(),
            t.Key("owner", optional=True):  t.Any(),
            t.Key("potential_value", optional=True):  t.Any(),
            t.Key("potential_value_template", optional=True):  t.Any(),
            t.Key("prediction_targets", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("realized_value", optional=True):  t.Any(),
            t.Key("stage", optional=True):  t.String(),
            t.Key("target_dates", optional=True):  t.List(t.Dict().allow_extra("*")),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        business_impact=None,
        description=None,
        feasibility=None,
        name=None,
        notes=None,
        owner=None,
        potential_value=None,
        potential_value_template=None,
        prediction_targets=None,
        realized_value=None,
        stage=None,
        target_dates=None,
    ):
        self.business_impact = business_impact
        self.description = description
        self.feasibility = feasibility
        self.name = name
        self.notes = notes
        self.owner = owner
        self.potential_value = potential_value
        self.potential_value_template = potential_value_template
        self.prediction_targets = prediction_targets
        self.realized_value = realized_value
        self.stage = stage
        self.target_dates = target_dates

    def __repr__(self):
        return (
            "UseCaseUpdate("
            "business_impact={0.business_impact}, "
            "description={0.description}, "
            "feasibility={0.feasibility}, "
            "name={0.name}, "
            "notes={0.notes}, "
            "owner={0.owner}, "
            "potential_value={0.potential_value}, "
            "potential_value_template={0.potential_value_template}, "
            "prediction_targets={0.prediction_targets}, "
            "realized_value={0.realized_value}, "
            "stage={0.stage}, "
            "target_dates={0.target_dates}, "
        ).format(self)
