#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class UseCaseValueTemplateClassificationData(APIObject):
    """
    Attributes
    ----------
    accuracy_improvement:float
         Accuracy improvement
    decisions_count:int
         Estimated number of decisions per year
    incorrect_decision_cost:float
         Estimated cost of an individual incorrect decision
    incorrect_decisions_count:int
         Estimated number of incorrect decisions per year
    """
    _converter = t.Dict(
        {
            t.Key("accuracy_improvement"):  t.Float(),
            t.Key("decisions_count"):  t.Int(),
            t.Key("incorrect_decision_cost"):  t.Float(),
            t.Key("incorrect_decisions_count"):  t.Int(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        accuracy_improvement,
        decisions_count,
        incorrect_decision_cost,
        incorrect_decisions_count,
    ):
        self.accuracy_improvement = accuracy_improvement
        self.decisions_count = decisions_count
        self.incorrect_decision_cost = incorrect_decision_cost
        self.incorrect_decisions_count = incorrect_decisions_count

    def __repr__(self):
        return (
            "UseCaseValueTemplateClassificationData("
            "accuracy_improvement={0.accuracy_improvement}, "
            "decisions_count={0.decisions_count}, "
            "incorrect_decision_cost={0.incorrect_decision_cost}, "
            "incorrect_decisions_count={0.incorrect_decisions_count}, "
        ).format(self)
