#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.use_case_value_template_parameter_with_schema import UseCaseValueTemplateParameterWithSchema

class UseCaseValueTemplateResponse(APIObject):
    """
    Attributes
    ----------
    description:str
         Description of Value Template
    schema:[UseCaseValueTemplateParameterWithSchema]
         Schema definition of all template parameters
    template_type:str
         The name of the use case value template to be retrieved
    title:str
         Title of Value Template
    """
    _converter = t.Dict(
        {
            t.Key("description"):  t.String(),
            t.Key("schema"):  t.List(t.Dict().allow_extra("*")),
            t.Key("template_type"):  t.String(),
            t.Key("title"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        description,
        schema,
        template_type,
        title,
    ):
        self.description = description
        self.schema = schema
        self.template_type = template_type
        self.title = title

    def __repr__(self):
        return (
            "UseCaseValueTemplateResponse("
            "description={0.description}, "
            "schema={0.schema}, "
            "template_type={0.template_type}, "
            "title={0.title}, "
        ).format(self)
