#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class UseCaseValueTemplateSchema(APIObject):
    """
    Attributes
    ----------
    element_type:str
         Possible types used for template variables
    label:str
         Label describing the represented value
    maximum:int, none_type
         Sets Maximum value if given
    minimum:int, none_type
         Sets Minimum value if given
    placeholder:str
         Text that can be used to prefill an input filed for the value
    unit:str, none_type
         Unit type. e.g. %
    """
    _converter = t.Dict(
        {
            t.Key("element_type"):  t.String(),
            t.Key("label"):  t.String(),
            t.Key("maximum"):  t.Int(),
            t.Key("minimum"):  t.Int(),
            t.Key("placeholder"):  t.String(),
            t.Key("unit"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        element_type,
        label,
        maximum,
        minimum,
        placeholder,
        unit,
    ):
        self.element_type = element_type
        self.label = label
        self.maximum = maximum
        self.minimum = minimum
        self.placeholder = placeholder
        self.unit = unit

    def __repr__(self):
        return (
            "UseCaseValueTemplateSchema("
            "element_type={0.element_type}, "
            "label={0.label}, "
            "maximum={0.maximum}, "
            "minimum={0.minimum}, "
            "placeholder={0.placeholder}, "
            "unit={0.unit}, "
        ).format(self)
